/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.apache.crimson.parser.XmlReader;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Resolver
implements EntityResolver {
    private boolean ignoringMIME;
    private Hashtable id2uri;
    private Hashtable id2resource;
    private Hashtable id2loader;
    private static final String[] types = new String[]{"application/xml", "text/xml", "text/plain", "text/html", "application/x-netcdf", "content/unknown"};

    public boolean isIgnoringMIME() {
        return this.ignoringMIME;
    }

    public void setIgnoringMIME(boolean bl2) {
        this.ignoringMIME = bl2;
    }

    private InputStream mapResource(String string) {
        if (string == null || this.id2resource == null) {
            return null;
        }
        String string2 = (String)this.id2resource.get(string);
        ClassLoader classLoader = null;
        if (string2 == null) {
            return null;
        }
        if (this.id2loader != null) {
            classLoader = (ClassLoader)this.id2loader.get(string);
        }
        if (classLoader == null) {
            return ClassLoader.getSystemResourceAsStream(string2);
        }
        return classLoader.getResourceAsStream(string2);
    }

    private String name2uri(String string) {
        if (string == null || this.id2uri == null) {
            return null;
        }
        return (String)this.id2uri.get(string);
    }

    public void registerCatalogEntry(String string, String string2) {
        if (this.id2uri == null) {
            this.id2uri = new Hashtable(17);
        }
        this.id2uri.put(string, string2);
    }

    public static InputSource createInputSource(File file) throws IOException {
        InputSource inputSource = new InputSource(XmlReader.createReader(new FileInputStream(file)));
        String string = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
        }
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!string.endsWith("/") && file.isDirectory()) {
            string = string + "/";
        }
        inputSource.setSystemId("file:" + string);
        return inputSource;
    }

    public static InputSource createInputSource(URL uRL, boolean bl2) throws IOException {
        InputSource inputSource;
        int n2;
        URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection && ((n2 = ((HttpURLConnection)uRLConnection).getResponseCode()) >= 400 && n2 <= 417 || n2 >= 500 && n2 <= 505)) {
            throw new IOException("Error in opening uri " + uRL + "status code=" + n2);
        }
        if (bl2) {
            String string = uRLConnection.getContentType();
            inputSource = Resolver.createInputSource(string, uRLConnection.getInputStream(), false, uRL.getProtocol());
        } else {
            inputSource = new InputSource(XmlReader.createReader(uRLConnection.getInputStream()));
        }
        inputSource.setSystemId(uRLConnection.getURL().toString());
        return inputSource;
    }

    public void registerCatalogEntry(String string, String string2, ClassLoader classLoader) {
        if (this.id2resource == null) {
            this.id2resource = new Hashtable(17);
        }
        this.id2resource.put(string, string2);
        if (classLoader != null) {
            if (this.id2loader == null) {
                this.id2loader = new Hashtable(17);
            }
            this.id2loader.put(string, classLoader);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws IOException, SAXException {
        InputSource inputSource;
        InputStream inputStream;
        String string3 = this.name2uri(string);
        if (string3 == null && (inputStream = this.mapResource(string)) != null) {
            string2 = "java:resource:" + (String)this.id2resource.get(string);
            inputSource = new InputSource(XmlReader.createReader(inputStream));
        } else {
            if (string3 != null) {
                string2 = string3;
            } else if (string2 == null) {
                return null;
            }
            URL uRL = new URL(string2);
            URLConnection uRLConnection = uRL.openConnection();
            string2 = uRLConnection.getURL().toString();
            if (this.ignoringMIME) {
                inputSource = new InputSource(XmlReader.createReader(uRLConnection.getInputStream()));
            } else {
                String string4 = uRLConnection.getContentType();
                inputSource = Resolver.createInputSource(string4, uRLConnection.getInputStream(), false, uRL.getProtocol());
            }
        }
        inputSource.setSystemId(string2);
        inputSource.setPublicId(string);
        return inputSource;
    }

    public static InputSource createInputSource(String string, InputStream inputStream, boolean bl2, String string2) throws IOException {
        String string3 = null;
        if (string != null) {
            int n2 = (string = string.toLowerCase()).indexOf(59);
            if (n2 != -1) {
                String string4 = string.substring(n2 + 1);
                string = string.substring(0, n2);
                n2 = string4.indexOf("charset");
                if (n2 != -1) {
                    if ((n2 = (string4 = string4.substring(n2 + 7)).indexOf(59)) != -1) {
                        string4 = string4.substring(0, n2);
                    }
                    if ((n2 = string4.indexOf(61)) != -1) {
                        if ((n2 = (string4 = string4.substring(n2 + 1)).indexOf(40)) != -1) {
                            string4 = string4.substring(0, n2);
                        }
                        if ((n2 = string4.indexOf(34)) != -1) {
                            string4 = string4.substring(n2 + 1);
                            string4 = string4.substring(0, string4.indexOf(34));
                        }
                        string3 = string4.trim();
                    }
                }
            }
            if (bl2) {
                boolean bl3 = false;
                for (int i2 = 0; i2 < types.length; ++i2) {
                    if (!types[i2].equals(string)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    throw new IOException("Not XML: " + string);
                }
            }
            if (string3 == null && (string = string.trim()).startsWith("text/") && !"file".equalsIgnoreCase(string2)) {
                string3 = "US-ASCII";
            }
        }
        InputSource inputSource = new InputSource(XmlReader.createReader(inputStream, string3));
        inputSource.setByteStream(inputStream);
        inputSource.setEncoding(string3);
        return inputSource;
    }
}

